/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.contraption.storage.item.simple;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.foundation.utility.CreateCodecs;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SimpleMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler> {
    public static final Codec<SimpleMountedStorage> CODEC = SimpleMountedStorage.codec(SimpleMountedStorage::new);

    public SimpleMountedStorage(MountedItemStorageType<?> type, ItemStackHandler handler) {
        super(type, handler);
    }

    public SimpleMountedStorage(ItemStackHandler handler) {
        this((MountedItemStorageType)AllMountedStorageTypes.SIMPLE.get(), handler);
    }

    public SimpleMountedStorage(SlottedStorage<ItemVariant> storage) {
        this(SimpleMountedStorage.copyToItemStackHandler(storage));
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        SlottedStorage slotted;
        Storage storage = (Storage)ItemStorage.SIDED.find(level, pos, state, be, null);
        if (storage instanceof SlottedStorage && this.validate((SlottedStorage<ItemVariant>)(slotted = (SlottedStorage)storage))) {
            try (Transaction t = Transaction.openOuter();){
                for (int i = 0; i < slotted.getSlotCount(); ++i) {
                    class_1799 stack;
                    SingleSlotStorage slot = slotted.getSlot(i);
                    if (!slot.isResourceBlank()) {
                        slot.extract((Object)((ItemVariant)slot.getResource()), slot.getAmount(), (TransactionContext)t);
                    }
                    if ((stack = this.getStackInSlot(i)).method_7960()) continue;
                    slot.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
                }
                t.commit();
            }
        }
    }

    protected boolean validate(SlottedStorage<ItemVariant> storage) {
        return this.getSlotCount() == storage.getSlotCount();
    }

    public static <T extends SimpleMountedStorage> Codec<T> codec(Function<ItemStackHandler, T> factory) {
        return CreateCodecs.ITEM_STACK_HANDLER.xmap(factory, storage -> (ItemStackHandler)storage.wrapped);
    }
}

